//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Diagnostics;

namespace WindowsForms
{
	/// <summary>
	/// Podsumowanie dla ThreadInfoPage.
	/// </summary>
	public class ThreadInfoPage : System.Windows.Forms.TabPage
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox threadId;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox basePriority;
		private System.Windows.Forms.TextBox currentPriority;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.TextBox priorityLevel;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.TextBox startAddress;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.TextBox startTime;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.TextBox threadState;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.TextBox threadWaitReason;
		private System.Windows.Forms.TextBox userProcessorTime;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.TextBox totalProcessorTime;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.TextBox privilegedProcessorTime;
		private System.Windows.Forms.Label label11;
		/// <summary> 
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ThreadInfoPage()
		{
			// To wywoanie jest wymagane przez Windows.Forms Form Designer.
			InitializeComponent();

			// TODO: Dodanie inicjalizacji po wywoaniu InitForm

		}

		public string TabName
		{
			set
			{
				Text = value;
			}
		}

		public int Id
		{
			set
			{
				threadId.Text = value.ToString();
			}
		}
		public int BasePriority
		{
			set
			{
				basePriority.Text = value.ToString();
			}
		}
		public int CurrentPriority
		{
			set
			{
				currentPriority.Text = value.ToString();
			}
		}
		public ThreadPriorityLevel PriorityLevel
		{
			set
			{
				priorityLevel.Text = value.ToString();
			}
		}
		public IntPtr StartAddress
		{
			set
			{
				startAddress.Text = "0x" + ((uint)value).ToString("X");
			}
		}
		public DateTime StartTime
		{
			set
			{
				startTime.Text = value.ToString();
			}
		}
		public ThreadState ThreadState
		{
			set
			{
				threadState.Text = value.ToString();
			}
		}
		public ThreadWaitReason WaitReason
		{
			set
			{
				threadWaitReason.Text = value.ToString();
			}
		}
		public TimeSpan UserProcessorTime
		{
			set
			{
				userProcessorTime.Text = value.ToString();
			}
		}
		public TimeSpan TotalProcessorTime
		{
			set
			{
				totalProcessorTime.Text = value.ToString();
			}
		}
		public TimeSpan PrivilegedProcessorTime
		{
			set
			{
				privilegedProcessorTime.Text = value.ToString();
			}
		}
		/// <summary> 
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.threadId = new System.Windows.Forms.TextBox();
			this.basePriority = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.currentPriority = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.priorityLevel = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.startAddress = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.startTime = new System.Windows.Forms.TextBox();
			this.label6 = new System.Windows.Forms.Label();
			this.threadState = new System.Windows.Forms.TextBox();
			this.label7 = new System.Windows.Forms.Label();
			this.threadWaitReason = new System.Windows.Forms.TextBox();
			this.label8 = new System.Windows.Forms.Label();
			this.userProcessorTime = new System.Windows.Forms.TextBox();
			this.label9 = new System.Windows.Forms.Label();
			this.totalProcessorTime = new System.Windows.Forms.TextBox();
			this.label10 = new System.Windows.Forms.Label();
			this.privilegedProcessorTime = new System.Windows.Forms.TextBox();
			this.label11 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(80, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Id";
			// 
			// threadId
			// 
			this.threadId.Location = new System.Drawing.Point(136, 8);
			this.threadId.Name = "threadId";
			this.threadId.ReadOnly = true;
			this.threadId.Size = new System.Drawing.Size(152, 20);
			this.threadId.TabIndex = 1;
			this.threadId.Text = "";
			this.threadId.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// basePriority
			// 
			this.basePriority.Location = new System.Drawing.Point(136, 32);
			this.basePriority.Name = "basePriority";
			this.basePriority.ReadOnly = true;
			this.basePriority.Size = new System.Drawing.Size(152, 20);
			this.basePriority.TabIndex = 3;
			this.basePriority.Text = "";
			this.basePriority.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 40);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(80, 16);
			this.label2.TabIndex = 2;
			this.label2.Text = "Priorytet bazowy";
			// 
			// currentPriority
			// 
			this.currentPriority.Location = new System.Drawing.Point(136, 56);
			this.currentPriority.Name = "currentPriority";
			this.currentPriority.ReadOnly = true;
			this.currentPriority.Size = new System.Drawing.Size(152, 20);
			this.currentPriority.TabIndex = 5;
			this.currentPriority.Text = "";
			this.currentPriority.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 64);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(80, 16);
			this.label3.TabIndex = 4;
			this.label3.Text = "Biecy priorytet";
			// 
			// priorityLevel
			// 
			this.priorityLevel.Location = new System.Drawing.Point(136, 80);
			this.priorityLevel.Name = "priorityLevel";
			this.priorityLevel.ReadOnly = true;
			this.priorityLevel.Size = new System.Drawing.Size(152, 20);
			this.priorityLevel.TabIndex = 7;
			this.priorityLevel.Text = "";
			this.priorityLevel.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 88);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(80, 16);
			this.label4.TabIndex = 6;
			this.label4.Text = "Poziom priorytetu";
			// 
			// startAddress
			// 
			this.startAddress.Location = new System.Drawing.Point(136, 104);
			this.startAddress.Name = "startAddress";
			this.startAddress.ReadOnly = true;
			this.startAddress.Size = new System.Drawing.Size(152, 20);
			this.startAddress.TabIndex = 9;
			this.startAddress.Text = "";
			this.startAddress.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(8, 112);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(80, 16);
			this.label5.TabIndex = 8;
			this.label5.Text = "Adres pocztkowy";
			// 
			// startTime
			// 
			this.startTime.Location = new System.Drawing.Point(136, 128);
			this.startTime.Name = "startTime";
			this.startTime.ReadOnly = true;
			this.startTime.Size = new System.Drawing.Size(152, 20);
			this.startTime.TabIndex = 11;
			this.startTime.Text = "";
			this.startTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(8, 136);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(80, 16);
			this.label6.TabIndex = 10;
			this.label6.Text = "Czas pocztkowy";
			// 
			// threadState
			// 
			this.threadState.Location = new System.Drawing.Point(136, 152);
			this.threadState.Name = "threadState";
			this.threadState.ReadOnly = true;
			this.threadState.Size = new System.Drawing.Size(152, 20);
			this.threadState.TabIndex = 13;
			this.threadState.Text = "";
			this.threadState.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label7
			// 
			this.label7.Location = new System.Drawing.Point(8, 160);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(80, 16);
			this.label7.TabIndex = 12;
			this.label7.Text = "Stan wtku";
			// 
			// threadWaitReason
			// 
			this.threadWaitReason.Location = new System.Drawing.Point(136, 176);
			this.threadWaitReason.Name = "threadWaitReason";
			this.threadWaitReason.ReadOnly = true;
			this.threadWaitReason.Size = new System.Drawing.Size(152, 20);
			this.threadWaitReason.TabIndex = 15;
			this.threadWaitReason.Text = "";
			this.threadWaitReason.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label8
			// 
			this.label8.Location = new System.Drawing.Point(8, 184);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(80, 16);
			this.label8.TabIndex = 14;
			this.label8.Text = "Przyczyna oczekiwania";
			// 
			// userProcessorTime
			// 
			this.userProcessorTime.Location = new System.Drawing.Point(136, 200);
			this.userProcessorTime.Name = "userProcessorTime";
			this.userProcessorTime.ReadOnly = true;
			this.userProcessorTime.Size = new System.Drawing.Size(152, 20);
			this.userProcessorTime.TabIndex = 17;
			this.userProcessorTime.Text = "";
			this.userProcessorTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label9
			// 
			this.label9.Location = new System.Drawing.Point(8, 208);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(80, 16);
			this.label9.TabIndex = 16;
			this.label9.Text = "Czas uytkownika";
			// 
			// totalProcessorTime
			// 
			this.totalProcessorTime.Location = new System.Drawing.Point(136, 248);
			this.totalProcessorTime.Name = "totalProcessorTime";
			this.totalProcessorTime.ReadOnly = true;
			this.totalProcessorTime.Size = new System.Drawing.Size(152, 20);
			this.totalProcessorTime.TabIndex = 19;
			this.totalProcessorTime.Text = "";
			this.totalProcessorTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label10
			// 
			this.label10.Location = new System.Drawing.Point(8, 256);
			this.label10.Name = "label10";
			this.label10.Size = new System.Drawing.Size(88, 16);
			this.label10.TabIndex = 18;
			this.label10.Text = "Cakowity czas";
			// 
			// privilegedProcessorTime
			// 
			this.privilegedProcessorTime.Location = new System.Drawing.Point(136, 224);
			this.privilegedProcessorTime.Name = "privilegedProcessorTime";
			this.privilegedProcessorTime.ReadOnly = true;
			this.privilegedProcessorTime.Size = new System.Drawing.Size(152, 20);
			this.privilegedProcessorTime.TabIndex = 21;
			this.privilegedProcessorTime.Text = "";
			this.privilegedProcessorTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label11
			// 
			this.label11.Location = new System.Drawing.Point(8, 232);
			this.label11.Name = "label11";
			this.label11.Size = new System.Drawing.Size(88, 16);
			this.label11.TabIndex = 20;
			this.label11.Text = "Czas uprzywilejowany";
			// 
			// ThreadInfoPage
			// 
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.privilegedProcessorTime,
																		  this.label11,
																		  this.totalProcessorTime,
																		  this.label10,
																		  this.userProcessorTime,
																		  this.label9,
																		  this.threadWaitReason,
																		  this.label8,
																		  this.threadState,
																		  this.label7,
																		  this.startTime,
																		  this.label6,
																		  this.startAddress,
																		  this.label5,
																		  this.priorityLevel,
																		  this.label4,
																		  this.currentPriority,
																		  this.label3,
																		  this.basePriority,
																		  this.label2,
																		  this.threadId,
																		  this.label1});
			this.Name = "ThreadInfoPage";
			this.Size = new System.Drawing.Size(296, 334);
			this.ResumeLayout(false);

		}
		#endregion
	}
}
